/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.gui.scroll_forge;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.gui.scroll_forge.ScrollForgeMenu;
import io.redspace.ironsspellbooks.gui.scroll_forge.network.ServerboundScrollForgeSelectSpell;
import io.redspace.ironsspellbooks.item.InkItem;
import io.redspace.ironsspellbooks.setup.Messages;
import io.redspace.ironsspellbooks.util.ModTags;
import io.redspace.ironsspellbooks.util.TooltipsUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ScrollForgeScreen
extends AbstractContainerScreen<ScrollForgeMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("irons_spellbooks", "textures/gui/scroll_forge.png");
    private static final int SPELL_LIST_X = 89;
    private static final int SPELL_LIST_Y = 15;
    private static final int SCROLL_BAR_X = 199;
    private static final int SCROLL_BAR_Y = 15;
    private static final int SCROLL_BAR_WIDTH = 12;
    private static final int SCROLL_BAR_HEIGHT = 56;
    public static final ResourceLocation RUNIC_FONT = new ResourceLocation("illageralt");
    public static final ResourceLocation ENCHANT_FONT = new ResourceLocation("alt");
    private List<SpellCardInfo> availableSpells;
    private ItemStack[] oldMenuSlots = new ItemStack[]{ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_};
    private AbstractSpell selectedSpell = SpellRegistry.none();
    private int scrollOffset;
    private boolean isScrollbarHeld;

    public ScrollForgeScreen(ScrollForgeMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97726_ = 218;
        this.f_97727_ = 166;
    }

    protected void m_7856_() {
        this.availableSpells = new ArrayList<SpellCardInfo>();
        this.generateSpellList();
        super.m_7856_();
    }

    public void m_7379_() {
        this.setSelectedSpell(SpellRegistry.none());
        this.resetList();
        super.m_7379_();
    }

    private void resetList() {
        InkItem inkItem;
        Item item;
        if (((ScrollForgeMenu)this.f_97732_).getInkSlot().m_7993_().m_41619_() || !((item = ((ScrollForgeMenu)this.f_97732_).getInkSlot().m_7993_().m_41720_()) instanceof InkItem) || (inkItem = (InkItem)item).getRarity().compareRarity(ServerConfigs.getSpellConfig(this.selectedSpell).minRarity()) < 0) {
            this.setSelectedSpell(SpellRegistry.none());
        }
        this.scrollOffset = 0;
        for (SpellCardInfo s : this.availableSpells) {
            this.m_169411_((GuiEventListener)s.button);
        }
        this.availableSpells.clear();
    }

    public void m_6305_(PoseStack pPoseStack, int mouseX, int mouseY, float delta) {
        this.m_7333_(pPoseStack);
        super.m_6305_(pPoseStack, mouseX, mouseY, delta);
        this.m_7025_(pPoseStack, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        this.setTexture(TEXTURE);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        float scrollOffset = Mth.m_14036_((float)((float)this.scrollOffset / (float)(this.totalRowCount() - 3)), (float)0.0f, (float)1.0f);
        this.m_93228_(poseStack, this.f_97735_ + 199, (int)((float)(this.f_97736_ + 15) + scrollOffset * 41.0f), this.f_97726_ + (this.isScrollbarHeld ? 12 : 0), 0, 12, 15);
        if (this.menuSlotsChanged()) {
            this.generateSpellList();
        }
        this.renderSpellList(poseStack, partialTick, mouseX, mouseY);
    }

    private boolean menuSlotsChanged() {
        if (((ScrollForgeMenu)this.f_97732_).getInkSlot().m_7993_().m_41720_() != this.oldMenuSlots[0].m_41720_() || ((ScrollForgeMenu)this.f_97732_).getFocusSlot().m_7993_().m_41720_() != this.oldMenuSlots[2].m_41720_()) {
            this.oldMenuSlots = new ItemStack[]{((ScrollForgeMenu)this.f_97732_).getInkSlot().m_7993_(), ((ScrollForgeMenu)this.f_97732_).getBlankScrollSlot().m_7993_(), ((ScrollForgeMenu)this.f_97732_).getFocusSlot().m_7993_()};
            return true;
        }
        return false;
    }

    private void renderSpellList(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        ItemStack inkStack = ((ScrollForgeMenu)this.f_97732_).getInkSlot().m_7993_();
        SpellRarity inkRarity = this.getRarityFromInk(inkStack.m_41720_());
        this.availableSpells.sort((a, b) -> ServerConfigs.getSpellConfig(a.spell).minRarity().compareRarity(ServerConfigs.getSpellConfig(b.spell).minRarity()));
        List<FormattedCharSequence> additionalTooltip = null;
        for (int i = 0; i < this.availableSpells.size(); ++i) {
            SpellCardInfo spellCard = this.availableSpells.get(i);
            if (i - this.scrollOffset >= 0 && i - this.scrollOffset < 3) {
                spellCard.activityState = inkRarity == null || spellCard.spell.getMinRarity() > inkRarity.getValue() ? SpellCardInfo.ActivityState.INK_ERROR : (this.f_96541_ != null && !spellCard.spell.canBeCraftedBy((Player)this.f_96541_.f_91074_) ? SpellCardInfo.ActivityState.UNLEARNED_ERROR : SpellCardInfo.ActivityState.ENABLED);
                int x = this.f_97735_ + 89;
                int y = this.f_97736_ + 15 + (i - this.scrollOffset) * 19;
                spellCard.button.f_93620_ = x;
                spellCard.button.f_93621_ = y;
                spellCard.draw(this, poseStack, x, y, mouseX, mouseY);
                if (additionalTooltip == null) {
                    additionalTooltip = spellCard.getTooltip(x, y, mouseX, mouseY);
                }
            } else {
                spellCard.activityState = SpellCardInfo.ActivityState.DISABLED;
            }
            spellCard.button.f_93623_ = spellCard.activityState == SpellCardInfo.ActivityState.ENABLED;
        }
        if (additionalTooltip != null) {
            this.m_96617_(poseStack, additionalTooltip, mouseX, mouseY);
        }
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double direction) {
        int newScroll = this.scrollOffset - (int)direction;
        int length = this.availableSpells.size();
        if (newScroll <= length - 3 && newScroll >= 0) {
            this.scrollOffset = (int)((double)this.scrollOffset - direction);
            return true;
        }
        return false;
    }

    public void generateSpellList() {
        this.resetList();
        ItemStack focusStack = ((ScrollForgeMenu)this.f_97732_).getFocusSlot().m_7993_();
        IronsSpellbooks.LOGGER.info("ScrollForgeMenu.generateSpellSlots.focus: {}", (Object)focusStack.m_41720_());
        if (!focusStack.m_41619_() && focusStack.m_204117_(ModTags.SCHOOL_FOCUS)) {
            SchoolType school = SchoolRegistry.getSchoolFromFocus(focusStack);
            List<AbstractSpell> spells = SpellRegistry.getSpellsForSchool(school).stream().filter(AbstractSpell::allowCrafting).toList();
            for (int i = 0; i < spells.size(); ++i) {
                int tempIndex = i;
                if (!spells.get(i).isEnabled() || this.f_96541_ == null) continue;
                this.availableSpells.add(new SpellCardInfo(spells.get(i), i + 1, i, (Button)this.m_7787_((GuiEventListener)new Button(0, 0, 108, 19, (Component)spells.get(i).getDisplayName((Player)this.f_96541_.f_91074_), b -> this.setSelectedSpell((AbstractSpell)spells.get(tempIndex))))));
            }
        }
    }

    private void setSelectedSpell(AbstractSpell spell) {
        this.selectedSpell = spell;
        Messages.sendToServer(new ServerboundScrollForgeSelectSpell(((ScrollForgeMenu)this.f_97732_).blockEntity.m_58899_(), spell.getSpellId()));
    }

    private SpellRarity getRarityFromInk(Item ink) {
        if (ink instanceof InkItem) {
            InkItem inkItem = (InkItem)ink;
            return inkItem.getRarity();
        }
        return null;
    }

    public AbstractSpell getSelectedSpell() {
        return this.selectedSpell;
    }

    private void setTexture(ResourceLocation texture) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        this.isScrollbarHeld = this.m_6774_(199, 15, 12, 56, pMouseX, pMouseY);
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        this.isScrollbarHeld = false;
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        int i = this.totalRowCount() - 3;
        if (this.isScrollbarHeld) {
            int j = this.f_97736_ + 15;
            int k = j + 56;
            float scrollOffs = ((float)pMouseY - (float)j - 7.5f) / ((float)(k - j) - 15.0f);
            scrollOffs = Mth.m_14036_((float)scrollOffs, (float)0.0f, (float)1.0f);
            this.scrollOffset = Math.max((int)((double)(scrollOffs * (float)i) + 0.5), 0);
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    private int totalRowCount() {
        return this.availableSpells.size();
    }

    private class SpellCardInfo {
        ActivityState activityState = ActivityState.DISABLED;
        AbstractSpell spell;
        int spellLevel;
        SpellRarity rarity;
        Button button;
        int index;

        SpellCardInfo(AbstractSpell spell, int spellLevel, int index, Button button) {
            this.spell = spell;
            this.spellLevel = spellLevel;
            this.index = index;
            this.button = button;
            this.rarity = spell.getRarity(spellLevel);
        }

        void draw(ScrollForgeScreen screen, PoseStack poseStack, int x, int y, int mouseX, int mouseY) {
            ScrollForgeScreen.this.setTexture(TEXTURE);
            if (this.activityState == ActivityState.ENABLED || this.activityState == ActivityState.UNLEARNED_ERROR) {
                if (this.spell == screen.getSelectedSpell()) {
                    screen.m_93228_(poseStack, x, y, 0, 204, 108, 19);
                } else {
                    screen.m_93228_(poseStack, x, y, 0, 166, 108, 19);
                }
            } else {
                screen.m_93228_(poseStack, x, y, 0, 185, 108, 19);
            }
            ScrollForgeScreen.this.setTexture(this.activityState == ActivityState.ENABLED ? this.spell.getSpellIconResource() : SpellRegistry.none().getSpellIconResource());
            ScrollForgeScreen.m_93133_((PoseStack)poseStack, (int)(x + 108 - 18), (int)(y + 1), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            int maxWidth = 88;
            FormattedText text = this.trimText(ScrollForgeScreen.this.f_96547_, (Component)this.getDisplayName().m_130948_(this.activityState == ActivityState.ENABLED ? Style.f_131099_ : Style.f_131099_.m_131150_(RUNIC_FONT)), maxWidth);
            int textX = x + 2;
            int textY = y + 3;
            ScrollForgeScreen.this.f_96547_.m_92857_(text, textX, textY, maxWidth, 0xFFFFFF);
        }

        @Nullable
        List<FormattedCharSequence> getTooltip(int x, int y, int mouseX, int mouseY) {
            MutableComponent text = this.getDisplayName();
            int textX = x + 2;
            int textY = y + 3;
            if (mouseX >= textX && mouseY >= textY && mouseX < textX + ScrollForgeScreen.this.f_96547_.m_92852_((FormattedText)text)) {
                Objects.requireNonNull(ScrollForgeScreen.this.f_96547_);
                if (mouseY < textY + 9) {
                    return this.getHoverText();
                }
            }
            return null;
        }

        List<FormattedCharSequence> getHoverText() {
            if (this.activityState == ActivityState.INK_ERROR) {
                return List.of(FormattedCharSequence.m_13714_((String)Component.m_237115_((String)"ui.irons_spellbooks.ink_rarity_error").getString(), (Style)Style.f_131099_));
            }
            if (this.activityState == ActivityState.UNLEARNED_ERROR) {
                return List.of(FormattedCharSequence.m_13714_((String)Component.m_237115_((String)"ui.irons_spellbooks.unlearned_error").getString(), (Style)Style.f_131099_));
            }
            return TooltipsUtils.createSpellDescriptionTooltip(this.spell, ScrollForgeScreen.this.f_96547_);
        }

        private FormattedText trimText(Font font, Component component, int maxWidth) {
            FormattedText text = (FormattedText)font.m_92865_().m_92414_((FormattedText)component, maxWidth, component.m_7383_()).get(0);
            if (text.getString().length() < component.getString().length()) {
                text = FormattedText.m_130773_((FormattedText[])new FormattedText[]{text, FormattedText.m_130775_((String)"...")});
            }
            return text;
        }

        MutableComponent getDisplayName() {
            return this.spell.getDisplayName((Player)((ScrollForgeScreen)ScrollForgeScreen.this).f_96541_.f_91074_);
        }

        static enum ActivityState {
            DISABLED,
            ENABLED,
            INK_ERROR,
            UNLEARNED_ERROR;

        }
    }
}

